<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use App\Models\Order;

class OrderPlacedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Order Confirmation')
            ->greeting('Hello ' . $notifiable->name . ',')
            ->line('Thank you for your order!')
            ->line('Order ID: ' . $this->order->id)
            ->line('Total Price: $' . $this->order->total_price)
            ->action('View Order', url('/orders/' . $this->order->id))
            ->line('We appreciate your business!');
    }
}